//FORWARD KINEMATICS OF A 6-JOINT INDUSTRIAL ROBOT
//describe 6 links using four Denavit-Hartenberg parameters(DH parameters).
// Here d ,a and alpha is defined for a standard industrial robot with 6 revolute joints
L1 = Link('d', 0.475, 'a', 0, 'alpha', 0);
L2 = Link('d', 0, 'a', 0.15, 'alpha', 1.571);
L3 = Link('d', 0, 'a', 0.6, 'alpha', 0);
L4 = Link('d', 0.72, 'a', 0.12, 'alpha', 1.571);
L5 = Link('d', 0, 'a', 0, 'alpha',-1.571);
L6 = Link('d', 0.085, 'a', 0, 'alpha', 1.571);

//joining the links to form the robot
L = list(L1,L2,L3,L4,L5,L6)
Robot = SerialLink(L, 'name', 'Robot')

/* change the default gravity vector to work in real environment, where gravity acts in z-direction with a magnitude of 9.81*/ 
Robot = SerialLink(L, 'gravity', [0; 0; 9.81])

//fkine is the function to do forward kinematics
//6 angle values are in radian
fkine(Robot,[0.2,0.2,0,0.3,0,0])

//using the same angle values the schematic of robot is plotted and named ROBO12
//position of end-effector and Roll-pitch-yaw angle can be changed in the teach
//R,P,Y is as ax,ay and az in the teach as defined by the toolbox 
plot_robot(Robot,[0.2,0.2,0,0.3,0,0])
teach(Robot)
//Using forward kinematics, we can find postion and rotation of end effector








